/***********************************************************************************/
/* 
 Sample Project: Using the Amyuni PDF Creator ActiveX version with C#
 
 In order to successfully run this sample, you will an evalutaion version of the
 Amyuni PDF Creator Developer Edition that you can download from the link below:
 
 http://www.amyuni.com/en/developer/pdfsuiteactivex
*/
/////////////////////////////////////////////////////////////////////////////////

using System;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Text;
using ACPDFCREACTIVEX;


namespace PDFCreator
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
    public class Form1 : Form
    {
        private IContainer components;
        private static int _intCounter;
        private const string StrLicenseTo = "Amyuni PDF Creator Evaluation";
        private const string StrActivationCode = "07EFCDAB010001004282943F13F19A88F332D9E781E40460726D79A42847A1BDE06DB61C1BE94E2D90424BF8762385335F9D6884E9FC";
        private TabControl _tabControl1;
        private TabPage _tabPage3;
        private Button _btnGetObjectsInRec;
        private Button _btnPrint;
        private Button _btnSavePage;
        private Button _btnEmbedFonts;
        private Button _btnUnDo;
        private Button _btnReDo;
        private TabPage _tabPage8;
        private Button _btnReachText;
        private Button _btnMovePages;
        private Button _btnDeletePage;
        private Button _btnDuplicatePages;
        private Button _btnMerge;
        private TabPage _tabPage9;
        private Button _btnExportToExcel;
        private Button _btnExportToHtml;
        private Button _btnExportToJpeg;
        private Button _btnExportToRtf;
        private Button _btnGetWarningLevel;
        private Button _btnMergeEx;
        private Button _btnAppendEx;
        private Button _btnGetDocProp;
        private Button _btnExportToTiff;
        private Button _btnDeleteObject;
        private Button _btnGetTextValue;
        private MainMenu _mainMenu1;
        private MenuItem _menuItem1;
        private MenuItem _menuItem2;
        private MenuItem _exit;
        private Button _btnRetreiveTextValue;
        private Button _btnEncrypt;
        private Button _btnSavePageEvent;        
        private Button _btnSetTextValue;
        private Button _btnAppendManyPages;
        private MenuItem _menuItem3;
        private Button _btnExportToXps;
        private Label _lblStatus;
        private TabPage _tabPage11;
        private Button _btnAddMetaData;
        private Button _btnReadMetaData;
        private TabPage _tabPage1;
        private Button _btnCreatePoly;
        private Button _btnLoadPicFile;
        private Button _btnCreateStickyNote;
        private Button _btnCreateArrow;
        private Button _btnCreateBookmarks;
        private Button _btnCreatePicObject;
        private Button _btnAutoHyperlinks;
        private Button _btnCreateCheckButton;
        private Button _btnLockAllObjects;
        private Button _btnActiveTool;
        private Button _btnRedrawObject;
        private Button _btnInitControl;
        private Button _cmdCreateMultiPage;
        private Button _btnCreateTable;
        private Button _btnDrawHighLighter;
        private Button _btnCreateTextObject;
        private Button _btnAppendMultipleDocs;
        private TabPage _tabPage4;
        private Button _btnGetFonts;
        private Button _btnSaveCloseLib;
        private Button _btnInsertAfterTheCurrentPage;
        private Button _btnInsertBeforeCurrentPage;
        private Button _btnInsertPdFatEnd;
        private Button _btnInsertPdfBegin;
        private Button _btnDigitalSignatures;
        private Button _btnPageNumber;
        private Button _btnSetAttributeForMultipleSelection;
        private Button _btnScrollWindow;
        private AxACPDFCREACTIVEX.AxPDFCreactiveX _axPdf;
        private Button _btnRotatePage;




        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
        }

        /* protected override void Dispose(bool disposing)FormToBinMap 
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        */
        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this._tabControl1 = new System.Windows.Forms.TabControl();
            this._tabPage1 = new System.Windows.Forms.TabPage();
            this._btnEncrypt = new System.Windows.Forms.Button();
            this._btnCreatePoly = new System.Windows.Forms.Button();
            this._btnEmbedFonts = new System.Windows.Forms.Button();
            this._btnLoadPicFile = new System.Windows.Forms.Button();
            this._btnCreateStickyNote = new System.Windows.Forms.Button();
            this._btnCreateArrow = new System.Windows.Forms.Button();
            this._btnCreateBookmarks = new System.Windows.Forms.Button();
            this._btnCreatePicObject = new System.Windows.Forms.Button();
            this._btnAutoHyperlinks = new System.Windows.Forms.Button();
            this._btnCreateCheckButton = new System.Windows.Forms.Button();
            this._btnLockAllObjects = new System.Windows.Forms.Button();
            this._btnActiveTool = new System.Windows.Forms.Button();
            this._btnRedrawObject = new System.Windows.Forms.Button();
            this._btnInitControl = new System.Windows.Forms.Button();
            this._cmdCreateMultiPage = new System.Windows.Forms.Button();
            this._btnCreateTable = new System.Windows.Forms.Button();
            this._btnDrawHighLighter = new System.Windows.Forms.Button();
            this._btnCreateTextObject = new System.Windows.Forms.Button();
            this._tabPage4 = new System.Windows.Forms.TabPage();
            this._btnPrint = new System.Windows.Forms.Button();
            this._btnReDo = new System.Windows.Forms.Button();
            this._btnSavePageEvent = new System.Windows.Forms.Button();
            this._btnSaveCloseLib = new System.Windows.Forms.Button();
            this._btnUnDo = new System.Windows.Forms.Button();
            this._btnDuplicatePages = new System.Windows.Forms.Button();
            this._btnDeletePage = new System.Windows.Forms.Button();
            this._btnMovePages = new System.Windows.Forms.Button();
            this._btnInsertAfterTheCurrentPage = new System.Windows.Forms.Button();
            this._btnSavePage = new System.Windows.Forms.Button();
            this._btnInsertBeforeCurrentPage = new System.Windows.Forms.Button();
            this._btnInsertPdFatEnd = new System.Windows.Forms.Button();
            this._btnInsertPdfBegin = new System.Windows.Forms.Button();
            this._btnDigitalSignatures = new System.Windows.Forms.Button();
            this._btnPageNumber = new System.Windows.Forms.Button();
            this._btnSetAttributeForMultipleSelection = new System.Windows.Forms.Button();
            this._btnScrollWindow = new System.Windows.Forms.Button();
            this._btnRotatePage = new System.Windows.Forms.Button();
            this._tabPage8 = new System.Windows.Forms.TabPage();
            this._btnAppendMultipleDocs = new System.Windows.Forms.Button();
            this._btnAppendEx = new System.Windows.Forms.Button();
            this._btnMergeEx = new System.Windows.Forms.Button();
            this._btnMerge = new System.Windows.Forms.Button();
            this._btnReachText = new System.Windows.Forms.Button();
            this._tabPage3 = new System.Windows.Forms.TabPage();
            this._btnAppendManyPages = new System.Windows.Forms.Button();
            this._btnSetTextValue = new System.Windows.Forms.Button();
            this._btnRetreiveTextValue = new System.Windows.Forms.Button();
            this._btnGetWarningLevel = new System.Windows.Forms.Button();
            this._btnGetFonts = new System.Windows.Forms.Button();
            this._btnGetTextValue = new System.Windows.Forms.Button();
            this._btnDeleteObject = new System.Windows.Forms.Button();
            this._btnGetDocProp = new System.Windows.Forms.Button();
            this._btnGetObjectsInRec = new System.Windows.Forms.Button();
            this._tabPage9 = new System.Windows.Forms.TabPage();
            this._btnExportToXps = new System.Windows.Forms.Button();
            this._btnExportToTiff = new System.Windows.Forms.Button();
            this._btnExportToRtf = new System.Windows.Forms.Button();
            this._btnExportToJpeg = new System.Windows.Forms.Button();
            this._btnExportToHtml = new System.Windows.Forms.Button();
            this._btnExportToExcel = new System.Windows.Forms.Button();
            this._tabPage11 = new System.Windows.Forms.TabPage();
            this._btnReadMetaData = new System.Windows.Forms.Button();
            this._btnAddMetaData = new System.Windows.Forms.Button();
            this._mainMenu1 = new System.Windows.Forms.MainMenu(this.components);
            this._menuItem1 = new System.Windows.Forms.MenuItem();
            this._menuItem2 = new System.Windows.Forms.MenuItem();
            this._exit = new System.Windows.Forms.MenuItem();
            this._menuItem3 = new System.Windows.Forms.MenuItem();
            this._lblStatus = new System.Windows.Forms.Label();
            this._axPdf = new AxACPDFCREACTIVEX.AxPDFCreactiveX();
            this._tabControl1.SuspendLayout();
            this._tabPage1.SuspendLayout();
            this._tabPage4.SuspendLayout();
            this._tabPage8.SuspendLayout();
            this._tabPage3.SuspendLayout();
            this._tabPage9.SuspendLayout();
            this._tabPage11.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._axPdf)).BeginInit();
            this.SuspendLayout();
            // 
            // tabControl1
            // 
            this._tabControl1.Controls.Add(this._tabPage1);
            this._tabControl1.Controls.Add(this._tabPage4);
            this._tabControl1.Controls.Add(this._tabPage8);
            this._tabControl1.Controls.Add(this._tabPage3);
            this._tabControl1.Controls.Add(this._tabPage9);
            this._tabControl1.Controls.Add(this._tabPage11);
            this._tabControl1.Location = new System.Drawing.Point(841, 12);
            this._tabControl1.Multiline = true;
            this._tabControl1.Name = "_tabControl1";
            this._tabControl1.SelectedIndex = 0;
            this._tabControl1.Size = new System.Drawing.Size(449, 470);
            this._tabControl1.TabIndex = 1;
            // 
            // tabPage1
            // 
            this._tabPage1.BackColor = System.Drawing.Color.Transparent;
            this._tabPage1.Controls.Add(this._btnEncrypt);
            this._tabPage1.Controls.Add(this._btnCreatePoly);
            this._tabPage1.Controls.Add(this._btnEmbedFonts);
            this._tabPage1.Controls.Add(this._btnLoadPicFile);
            this._tabPage1.Controls.Add(this._btnCreateStickyNote);
            this._tabPage1.Controls.Add(this._btnCreateArrow);
            this._tabPage1.Controls.Add(this._btnCreateBookmarks);
            this._tabPage1.Controls.Add(this._btnCreatePicObject);
            this._tabPage1.Controls.Add(this._btnAutoHyperlinks);
            this._tabPage1.Controls.Add(this._btnCreateCheckButton);
            this._tabPage1.Controls.Add(this._btnLockAllObjects);
            this._tabPage1.Controls.Add(this._btnActiveTool);
            this._tabPage1.Controls.Add(this._btnRedrawObject);
            this._tabPage1.Controls.Add(this._btnInitControl);
            this._tabPage1.Controls.Add(this._cmdCreateMultiPage);
            this._tabPage1.Controls.Add(this._btnCreateTable);
            this._tabPage1.Controls.Add(this._btnDrawHighLighter);
            this._tabPage1.Controls.Add(this._btnCreateTextObject);
            this._tabPage1.Location = new System.Drawing.Point(4, 46);
            this._tabPage1.Name = "_tabPage1";
            this._tabPage1.Size = new System.Drawing.Size(441, 420);
            this._tabPage1.TabIndex = 0;
            this._tabPage1.Text = "Create Objects";
            this._tabPage1.UseVisualStyleBackColor = true;
            // 
            // btnEncrypt
            // 
            this._btnEncrypt.Location = new System.Drawing.Point(206, 190);
            this._btnEncrypt.Name = "_btnEncrypt";
            this._btnEncrypt.Size = new System.Drawing.Size(174, 37);
            this._btnEncrypt.TabIndex = 0;
            this._btnEncrypt.Text = "Encrypt";
            this._btnEncrypt.Click += new System.EventHandler(this.btnEncrypt_Click);
            // 
            // btnCreatePoly
            // 
            this._btnCreatePoly.Location = new System.Drawing.Point(10, 276);
            this._btnCreatePoly.Name = "_btnCreatePoly";
            this._btnCreatePoly.Size = new System.Drawing.Size(174, 37);
            this._btnCreatePoly.TabIndex = 21;
            this._btnCreatePoly.Text = "Create Ploy";
            this._btnCreatePoly.Click += new System.EventHandler(this.btnCreatePoly_Click);
            // 
            // btnEmbedFonts
            // 
            this._btnEmbedFonts.Location = new System.Drawing.Point(206, 147);
            this._btnEmbedFonts.Name = "_btnEmbedFonts";
            this._btnEmbedFonts.Size = new System.Drawing.Size(174, 37);
            this._btnEmbedFonts.TabIndex = 5;
            this._btnEmbedFonts.Text = "Embed Fonts";
            this._btnEmbedFonts.Click += new System.EventHandler(this.btnEmbedFonts_Click);
            // 
            // btnLoadPicFile
            // 
            this._btnLoadPicFile.Location = new System.Drawing.Point(206, 106);
            this._btnLoadPicFile.Name = "_btnLoadPicFile";
            this._btnLoadPicFile.Size = new System.Drawing.Size(174, 37);
            this._btnLoadPicFile.TabIndex = 19;
            this._btnLoadPicFile.Text = "Load Pc File";
            this._btnLoadPicFile.Click += new System.EventHandler(this.btnLoadPicFile_Click);
            // 
            // btnCreateStickyNote
            // 
            this._btnCreateStickyNote.Location = new System.Drawing.Point(206, 233);
            this._btnCreateStickyNote.Name = "_btnCreateStickyNote";
            this._btnCreateStickyNote.Size = new System.Drawing.Size(174, 37);
            this._btnCreateStickyNote.TabIndex = 18;
            this._btnCreateStickyNote.Text = "Create StickyNote";
            this._btnCreateStickyNote.Click += new System.EventHandler(this.btnCreateStickyNote_Click);
            // 
            // btnCreateArrow
            // 
            this._btnCreateArrow.Location = new System.Drawing.Point(206, 276);
            this._btnCreateArrow.Name = "_btnCreateArrow";
            this._btnCreateArrow.Size = new System.Drawing.Size(174, 37);
            this._btnCreateArrow.TabIndex = 17;
            this._btnCreateArrow.Text = "Create Arrow";
            this._btnCreateArrow.Click += new System.EventHandler(this.btnCreateArrow_Click);
            // 
            // btnCreateBookmarks
            // 
            this._btnCreateBookmarks.Location = new System.Drawing.Point(206, 319);
            this._btnCreateBookmarks.Name = "_btnCreateBookmarks";
            this._btnCreateBookmarks.Size = new System.Drawing.Size(174, 37);
            this._btnCreateBookmarks.TabIndex = 16;
            this._btnCreateBookmarks.Text = "Create Bookmarks";
            this._btnCreateBookmarks.Click += new System.EventHandler(this.btnCreateBookmarks_Click);
            // 
            // btnCreatePicObject
            // 
            this._btnCreatePicObject.Location = new System.Drawing.Point(10, 319);
            this._btnCreatePicObject.Name = "_btnCreatePicObject";
            this._btnCreatePicObject.Size = new System.Drawing.Size(174, 37);
            this._btnCreatePicObject.TabIndex = 13;
            this._btnCreatePicObject.Text = "Create Picture Object";
            this._btnCreatePicObject.Click += new System.EventHandler(this.btnCreatePicObject_Click);
            // 
            // btnAutoHyperlinks
            // 
            this._btnAutoHyperlinks.Location = new System.Drawing.Point(10, 362);
            this._btnAutoHyperlinks.Name = "_btnAutoHyperlinks";
            this._btnAutoHyperlinks.Size = new System.Drawing.Size(174, 37);
            this._btnAutoHyperlinks.TabIndex = 11;
            this._btnAutoHyperlinks.Text = "Auto Hyperlinks";
            this._btnAutoHyperlinks.Click += new System.EventHandler(this.btnAutoHyperlinks_Click);
            // 
            // btnCreateCheckButton
            // 
            this._btnCreateCheckButton.Location = new System.Drawing.Point(206, 62);
            this._btnCreateCheckButton.Name = "_btnCreateCheckButton";
            this._btnCreateCheckButton.Size = new System.Drawing.Size(174, 37);
            this._btnCreateCheckButton.TabIndex = 9;
            this._btnCreateCheckButton.Text = "Create Checkbutton";
            this._btnCreateCheckButton.Click += new System.EventHandler(this.btnCreateCheckButton_Click);
            // 
            // btnLockAllObjects
            // 
            this._btnLockAllObjects.Location = new System.Drawing.Point(206, 18);
            this._btnLockAllObjects.Name = "_btnLockAllObjects";
            this._btnLockAllObjects.Size = new System.Drawing.Size(174, 37);
            this._btnLockAllObjects.TabIndex = 8;
            this._btnLockAllObjects.Text = "Lock All Objects";
            this._btnLockAllObjects.Click += new System.EventHandler(this.btnLockAllObjects_Click);
            // 
            // btnActiveTool
            // 
            this._btnActiveTool.Location = new System.Drawing.Point(10, 233);
            this._btnActiveTool.Name = "_btnActiveTool";
            this._btnActiveTool.Size = new System.Drawing.Size(174, 37);
            this._btnActiveTool.TabIndex = 7;
            this._btnActiveTool.Text = "Active Tool";
            this._btnActiveTool.Click += new System.EventHandler(this.btnActiveTool_Click);
            // 
            // btnRedrawObject
            // 
            this._btnRedrawObject.Location = new System.Drawing.Point(10, 190);
            this._btnRedrawObject.Name = "_btnRedrawObject";
            this._btnRedrawObject.Size = new System.Drawing.Size(174, 37);
            this._btnRedrawObject.TabIndex = 6;
            this._btnRedrawObject.Text = "ReDraw Object";
            this._btnRedrawObject.Click += new System.EventHandler(this.btnRedrawObject_Click);
            // 
            // btnInitControl
            // 
            this._btnInitControl.Location = new System.Drawing.Point(206, 362);
            this._btnInitControl.Name = "_btnInitControl";
            this._btnInitControl.Size = new System.Drawing.Size(174, 37);
            this._btnInitControl.TabIndex = 4;
            this._btnInitControl.Text = "Clear Control";
            this._btnInitControl.Click += new System.EventHandler(this.btnInitControl_Click);
            // 
            // cmdCreateMultiPage
            // 
            this._cmdCreateMultiPage.Location = new System.Drawing.Point(10, 147);
            this._cmdCreateMultiPage.Name = "_cmdCreateMultiPage";
            this._cmdCreateMultiPage.Size = new System.Drawing.Size(174, 37);
            this._cmdCreateMultiPage.TabIndex = 3;
            this._cmdCreateMultiPage.Text = "Create Multi Page";
            this._cmdCreateMultiPage.Click += new System.EventHandler(this.cmdCreateMultiPage_Click);
            // 
            // btnCreateTable
            // 
            this._btnCreateTable.Location = new System.Drawing.Point(10, 104);
            this._btnCreateTable.Name = "_btnCreateTable";
            this._btnCreateTable.Size = new System.Drawing.Size(174, 37);
            this._btnCreateTable.TabIndex = 2;
            this._btnCreateTable.Text = "Create Table";
            this._btnCreateTable.Click += new System.EventHandler(this.btnCreateTable_Click);
            // 
            // btnDrawHighLighter
            // 
            this._btnDrawHighLighter.Location = new System.Drawing.Point(10, 61);
            this._btnDrawHighLighter.Name = "_btnDrawHighLighter";
            this._btnDrawHighLighter.Size = new System.Drawing.Size(174, 37);
            this._btnDrawHighLighter.TabIndex = 1;
            this._btnDrawHighLighter.Text = "draw HighLight";
            this._btnDrawHighLighter.Click += new System.EventHandler(this.btnDrawHighLighter_Click);
            // 
            // btnCreateTextObject
            // 
            this._btnCreateTextObject.Location = new System.Drawing.Point(10, 18);
            this._btnCreateTextObject.Name = "_btnCreateTextObject";
            this._btnCreateTextObject.Size = new System.Drawing.Size(174, 37);
            this._btnCreateTextObject.TabIndex = 0;
            this._btnCreateTextObject.Text = "Create Text Object";
            this._btnCreateTextObject.Click += new System.EventHandler(this.btnCreateTextObject_Click);
            // 
            // tabPage4
            // 
            this._tabPage4.Controls.Add(this._btnPrint);
            this._tabPage4.Controls.Add(this._btnReDo);
            this._tabPage4.Controls.Add(this._btnSavePageEvent);
            this._tabPage4.Controls.Add(this._btnSaveCloseLib);
            this._tabPage4.Controls.Add(this._btnUnDo);
            this._tabPage4.Controls.Add(this._btnDuplicatePages);
            this._tabPage4.Controls.Add(this._btnDeletePage);
            this._tabPage4.Controls.Add(this._btnMovePages);
            this._tabPage4.Controls.Add(this._btnInsertAfterTheCurrentPage);
            this._tabPage4.Controls.Add(this._btnSavePage);
            this._tabPage4.Controls.Add(this._btnInsertBeforeCurrentPage);
            this._tabPage4.Controls.Add(this._btnInsertPdFatEnd);
            this._tabPage4.Controls.Add(this._btnInsertPdfBegin);
            this._tabPage4.Controls.Add(this._btnDigitalSignatures);
            this._tabPage4.Controls.Add(this._btnPageNumber);
            this._tabPage4.Controls.Add(this._btnSetAttributeForMultipleSelection);
            this._tabPage4.Controls.Add(this._btnScrollWindow);
            this._tabPage4.Controls.Add(this._btnRotatePage);
            this._tabPage4.Location = new System.Drawing.Point(4, 46);
            this._tabPage4.Name = "_tabPage4";
            this._tabPage4.Size = new System.Drawing.Size(441, 420);
            this._tabPage4.TabIndex = 3;
            this._tabPage4.Text = "Misc.  Code";
            this._tabPage4.UseVisualStyleBackColor = true;
            // 
            // btnPrint
            // 
            this._btnPrint.Location = new System.Drawing.Point(19, 319);
            this._btnPrint.Name = "_btnPrint";
            this._btnPrint.Size = new System.Drawing.Size(174, 37);
            this._btnPrint.TabIndex = 4;
            this._btnPrint.Text = "Print Document Page";
            this._btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // btnReDo
            // 
            this._btnReDo.Location = new System.Drawing.Point(19, 276);
            this._btnReDo.Name = "_btnReDo";
            this._btnReDo.Size = new System.Drawing.Size(174, 37);
            this._btnReDo.TabIndex = 6;
            this._btnReDo.Text = "ReDo";
            this._btnReDo.Click += new System.EventHandler(this.btnReDo_Click);
            // 
            // btnSavePageEvent
            // 
            this._btnSavePageEvent.Location = new System.Drawing.Point(217, 190);
            this._btnSavePageEvent.Name = "_btnSavePageEvent";
            this._btnSavePageEvent.Size = new System.Drawing.Size(174, 37);
            this._btnSavePageEvent.TabIndex = 7;
            this._btnSavePageEvent.Text = "Save Page Event";
            this._btnSavePageEvent.Click += new System.EventHandler(this.btnSavePageEvent_Click);
            // 
            // btnSaveCloseLib
            // 
            this._btnSaveCloseLib.Location = new System.Drawing.Point(19, 362);
            this._btnSaveCloseLib.Name = "_btnSaveCloseLib";
            this._btnSaveCloseLib.Size = new System.Drawing.Size(174, 37);
            this._btnSaveCloseLib.TabIndex = 20;
            this._btnSaveCloseLib.Text = "Save  plus  Close Lib";
            this._btnSaveCloseLib.Click += new System.EventHandler(this.btnSaveCloseLib_Click);
            // 
            // btnUnDo
            // 
            this._btnUnDo.Location = new System.Drawing.Point(19, 233);
            this._btnUnDo.Name = "_btnUnDo";
            this._btnUnDo.Size = new System.Drawing.Size(174, 37);
            this._btnUnDo.TabIndex = 5;
            this._btnUnDo.Text = "UnDo";
            this._btnUnDo.Click += new System.EventHandler(this.btnUnDo_Click);
            // 
            // btnDuplicatePages
            // 
            this._btnDuplicatePages.Location = new System.Drawing.Point(217, 233);
            this._btnDuplicatePages.Name = "_btnDuplicatePages";
            this._btnDuplicatePages.Size = new System.Drawing.Size(174, 37);
            this._btnDuplicatePages.TabIndex = 5;
            this._btnDuplicatePages.Text = "Duplicate Page";
            this._btnDuplicatePages.Click += new System.EventHandler(this.btnDuplicatePages_Click);
            // 
            // btnDeletePage
            // 
            this._btnDeletePage.Location = new System.Drawing.Point(217, 276);
            this._btnDeletePage.Name = "_btnDeletePage";
            this._btnDeletePage.Size = new System.Drawing.Size(174, 37);
            this._btnDeletePage.TabIndex = 4;
            this._btnDeletePage.Text = "Delete Pages";
            this._btnDeletePage.Click += new System.EventHandler(this.btnDeletePage_Click);
            // 
            // btnMovePages
            // 
            this._btnMovePages.Location = new System.Drawing.Point(217, 319);
            this._btnMovePages.Name = "_btnMovePages";
            this._btnMovePages.Size = new System.Drawing.Size(174, 37);
            this._btnMovePages.TabIndex = 3;
            this._btnMovePages.Text = "Move Pages";
            this._btnMovePages.Click += new System.EventHandler(this.btnMovePages_Click);
            // 
            // btnInsertAfterTheCurrentPage
            // 
            this._btnInsertAfterTheCurrentPage.Location = new System.Drawing.Point(217, 147);
            this._btnInsertAfterTheCurrentPage.Name = "_btnInsertAfterTheCurrentPage";
            this._btnInsertAfterTheCurrentPage.Size = new System.Drawing.Size(174, 37);
            this._btnInsertAfterTheCurrentPage.TabIndex = 16;
            this._btnInsertAfterTheCurrentPage.Text = "Insert After Current Page";
            this._btnInsertAfterTheCurrentPage.Click += new System.EventHandler(this.btnInsertAfterTheCurrentPage_Click);
            // 
            // btnSavePage
            // 
            this._btnSavePage.Location = new System.Drawing.Point(217, 362);
            this._btnSavePage.Name = "_btnSavePage";
            this._btnSavePage.Size = new System.Drawing.Size(174, 37);
            this._btnSavePage.TabIndex = 2;
            this._btnSavePage.Text = "Save Page";
            this._btnSavePage.Click += new System.EventHandler(this.btnSavePage_Click);
            // 
            // btnInsertBeforeCurrentPage
            // 
            this._btnInsertBeforeCurrentPage.Location = new System.Drawing.Point(217, 104);
            this._btnInsertBeforeCurrentPage.Name = "_btnInsertBeforeCurrentPage";
            this._btnInsertBeforeCurrentPage.Size = new System.Drawing.Size(174, 37);
            this._btnInsertBeforeCurrentPage.TabIndex = 14;
            this._btnInsertBeforeCurrentPage.Text = "Insert Before Current Page";
            this._btnInsertBeforeCurrentPage.Click += new System.EventHandler(this.btnInsertBeforeCurrentPage_Click);
            // 
            // btnInsertPDFatEnd
            // 
            this._btnInsertPdFatEnd.Location = new System.Drawing.Point(217, 61);
            this._btnInsertPdFatEnd.Name = "_btnInsertPdFatEnd";
            this._btnInsertPdFatEnd.Size = new System.Drawing.Size(174, 37);
            this._btnInsertPdFatEnd.TabIndex = 13;
            this._btnInsertPdFatEnd.Text = "Insert PDF at End";
            this._btnInsertPdFatEnd.Click += new System.EventHandler(this.btnInsertPDFatEnd_Click);
            // 
            // btnInsertPDFBegin
            // 
            this._btnInsertPdfBegin.Location = new System.Drawing.Point(217, 18);
            this._btnInsertPdfBegin.Name = "_btnInsertPdfBegin";
            this._btnInsertPdfBegin.Size = new System.Drawing.Size(174, 37);
            this._btnInsertPdfBegin.TabIndex = 12;
            this._btnInsertPdfBegin.Text = "Insert PDF at Begin";
            this._btnInsertPdfBegin.Click += new System.EventHandler(this.btnInsertPDFBegin_Click);
            // 
            // btnDigitalSignatures
            // 
            this._btnDigitalSignatures.Location = new System.Drawing.Point(19, 190);
            this._btnDigitalSignatures.Name = "_btnDigitalSignatures";
            this._btnDigitalSignatures.Size = new System.Drawing.Size(174, 37);
            this._btnDigitalSignatures.TabIndex = 10;
            this._btnDigitalSignatures.Text = "Digital Signtures";
            this._btnDigitalSignatures.Click += new System.EventHandler(this.btnDigitalSignatures_Click);
            // 
            // btnPageNumber
            // 
            this._btnPageNumber.Location = new System.Drawing.Point(19, 147);
            this._btnPageNumber.Name = "_btnPageNumber";
            this._btnPageNumber.Size = new System.Drawing.Size(174, 37);
            this._btnPageNumber.TabIndex = 8;
            this._btnPageNumber.Text = "Page Number";
            this._btnPageNumber.Click += new System.EventHandler(this.btnPageNumber_Click);
            // 
            // btnSetAttributeForMultipleSelection
            // 
            this._btnSetAttributeForMultipleSelection.Location = new System.Drawing.Point(19, 104);
            this._btnSetAttributeForMultipleSelection.Name = "_btnSetAttributeForMultipleSelection";
            this._btnSetAttributeForMultipleSelection.Size = new System.Drawing.Size(174, 37);
            this._btnSetAttributeForMultipleSelection.TabIndex = 6;
            this._btnSetAttributeForMultipleSelection.Text = "SetAttributeForMultipleSelection";
            this._btnSetAttributeForMultipleSelection.Click += new System.EventHandler(this.btnSetAttributeForMultipleSelection_Click);
            // 
            // btnScrollWindow
            // 
            this._btnScrollWindow.Location = new System.Drawing.Point(19, 61);
            this._btnScrollWindow.Name = "_btnScrollWindow";
            this._btnScrollWindow.Size = new System.Drawing.Size(174, 37);
            this._btnScrollWindow.TabIndex = 5;
            this._btnScrollWindow.Text = "Scroll Window";
            this._btnScrollWindow.Click += new System.EventHandler(this.btnScrollWindow_Click);
            // 
            // btnRotatePage
            // 
            this._btnRotatePage.Location = new System.Drawing.Point(19, 18);
            this._btnRotatePage.Name = "_btnRotatePage";
            this._btnRotatePage.Size = new System.Drawing.Size(174, 37);
            this._btnRotatePage.TabIndex = 4;
            this._btnRotatePage.Text = "Rotate Page";
            this._btnRotatePage.Click += new System.EventHandler(this.btnRotatePage_Click);
            // 
            // tabPage8
            // 
            this._tabPage8.Controls.Add(this._btnAppendMultipleDocs);
            this._tabPage8.Controls.Add(this._btnAppendEx);
            this._tabPage8.Controls.Add(this._btnMergeEx);
            this._tabPage8.Controls.Add(this._btnMerge);
            this._tabPage8.Controls.Add(this._btnReachText);
            this._tabPage8.Location = new System.Drawing.Point(4, 46);
            this._tabPage8.Name = "_tabPage8";
            this._tabPage8.Size = new System.Drawing.Size(441, 420);
            this._tabPage8.TabIndex = 7;
            this._tabPage8.Text = "Reach Append Merge";
            this._tabPage8.UseVisualStyleBackColor = true;
            // 
            // btnAppendMultipleDocs
            // 
            this._btnAppendMultipleDocs.Location = new System.Drawing.Point(10, 194);
            this._btnAppendMultipleDocs.Name = "_btnAppendMultipleDocs";
            this._btnAppendMultipleDocs.Size = new System.Drawing.Size(174, 37);
            this._btnAppendMultipleDocs.TabIndex = 6;
            this._btnAppendMultipleDocs.Text = "Append Multi Docs";
            this._btnAppendMultipleDocs.Click += new System.EventHandler(this.btnAppendMultipleDocs_Click);
            // 
            // btnAppendEx
            // 
            this._btnAppendEx.Location = new System.Drawing.Point(10, 62);
            this._btnAppendEx.Name = "_btnAppendEx";
            this._btnAppendEx.Size = new System.Drawing.Size(174, 37);
            this._btnAppendEx.TabIndex = 5;
            this._btnAppendEx.Text = "AppendEx Docs";
            this._btnAppendEx.Click += new System.EventHandler(this.btnAppendEx_Click);
            // 
            // btnMergeEx
            // 
            this._btnMergeEx.Location = new System.Drawing.Point(10, 106);
            this._btnMergeEx.Name = "_btnMergeEx";
            this._btnMergeEx.Size = new System.Drawing.Size(174, 37);
            this._btnMergeEx.TabIndex = 4;
            this._btnMergeEx.Text = "MergeEx Files";
            this._btnMergeEx.Click += new System.EventHandler(this.btnMergeEx_Click);
            // 
            // btnMerge
            // 
            this._btnMerge.Location = new System.Drawing.Point(10, 150);
            this._btnMerge.Name = "_btnMerge";
            this._btnMerge.Size = new System.Drawing.Size(174, 37);
            this._btnMerge.TabIndex = 3;
            this._btnMerge.Text = "Merge Files";
            this._btnMerge.Click += new System.EventHandler(this.btnMerge_Click);
            // 
            // btnReachText
            // 
            this._btnReachText.Location = new System.Drawing.Point(10, 18);
            this._btnReachText.Name = "_btnReachText";
            this._btnReachText.Size = new System.Drawing.Size(174, 37);
            this._btnReachText.TabIndex = 1;
            this._btnReachText.Text = "ReachText";
            this._btnReachText.Click += new System.EventHandler(this.btnReachText_Click);
            // 
            // tabPage3
            // 
            this._tabPage3.Controls.Add(this._btnAppendManyPages);
            this._tabPage3.Controls.Add(this._btnSetTextValue);
            this._tabPage3.Controls.Add(this._btnRetreiveTextValue);
            this._tabPage3.Controls.Add(this._btnGetWarningLevel);
            this._tabPage3.Controls.Add(this._btnGetFonts);
            this._tabPage3.Controls.Add(this._btnGetTextValue);
            this._tabPage3.Controls.Add(this._btnDeleteObject);
            this._tabPage3.Controls.Add(this._btnGetDocProp);
            this._tabPage3.Controls.Add(this._btnGetObjectsInRec);
            this._tabPage3.Location = new System.Drawing.Point(4, 46);
            this._tabPage3.Name = "_tabPage3";
            this._tabPage3.Size = new System.Drawing.Size(441, 420);
            this._tabPage3.TabIndex = 2;
            this._tabPage3.Text = "Retrieve Info";
            this._tabPage3.UseVisualStyleBackColor = true;
            // 
            // btnAppendManyPages
            // 
            this._btnAppendManyPages.Location = new System.Drawing.Point(19, 276);
            this._btnAppendManyPages.Name = "_btnAppendManyPages";
            this._btnAppendManyPages.Size = new System.Drawing.Size(174, 37);
            this._btnAppendManyPages.TabIndex = 9;
            this._btnAppendManyPages.Text = "Append Many Pages";
            // 
            // btnSetTextValue
            // 
            this._btnSetTextValue.Location = new System.Drawing.Point(19, 233);
            this._btnSetTextValue.Name = "_btnSetTextValue";
            this._btnSetTextValue.Size = new System.Drawing.Size(174, 37);
            this._btnSetTextValue.TabIndex = 8;
            this._btnSetTextValue.Text = "Set Text Value";
            this._btnSetTextValue.Click += new System.EventHandler(this.btnSetTextValue_Click);
            // 
            // btnRetreiveTextValue
            // 
            this._btnRetreiveTextValue.Location = new System.Drawing.Point(19, 190);
            this._btnRetreiveTextValue.Name = "_btnRetreiveTextValue";
            this._btnRetreiveTextValue.Size = new System.Drawing.Size(174, 37);
            this._btnRetreiveTextValue.TabIndex = 7;
            this._btnRetreiveTextValue.Text = "Retreive Text  Value";
            this._btnRetreiveTextValue.Click += new System.EventHandler(this.btnRetreiveTextValue_Click);
            // 
            // btnGetWarningLevel
            // 
            this._btnGetWarningLevel.Location = new System.Drawing.Point(19, 362);
            this._btnGetWarningLevel.Name = "_btnGetWarningLevel";
            this._btnGetWarningLevel.Size = new System.Drawing.Size(174, 37);
            this._btnGetWarningLevel.TabIndex = 6;
            this._btnGetWarningLevel.Text = "Get Warning Level";
            this._btnGetWarningLevel.Click += new System.EventHandler(this.btnGetWarningLevel_Click);
            // 
            // btnGetFonts
            // 
            this._btnGetFonts.Location = new System.Drawing.Point(19, 319);
            this._btnGetFonts.Name = "_btnGetFonts";
            this._btnGetFonts.Size = new System.Drawing.Size(174, 37);
            this._btnGetFonts.TabIndex = 24;
            this._btnGetFonts.Text = "Get Fonts";
            this._btnGetFonts.Click += new System.EventHandler(this.btnGetFonts_Click);
            // 
            // btnGetTextValue
            // 
            this._btnGetTextValue.Location = new System.Drawing.Point(19, 147);
            this._btnGetTextValue.Name = "_btnGetTextValue";
            this._btnGetTextValue.Size = new System.Drawing.Size(174, 37);
            this._btnGetTextValue.TabIndex = 6;
            this._btnGetTextValue.Text = "Get Text Value";
            this._btnGetTextValue.Click += new System.EventHandler(this.btnGetTextValue_Click);
            // 
            // btnDeleteObject
            // 
            this._btnDeleteObject.Location = new System.Drawing.Point(19, 104);
            this._btnDeleteObject.Name = "_btnDeleteObject";
            this._btnDeleteObject.Size = new System.Drawing.Size(174, 37);
            this._btnDeleteObject.TabIndex = 5;
            this._btnDeleteObject.Text = "Delete Object";
            this._btnDeleteObject.Click += new System.EventHandler(this.btnDeleteObject_Click_1);
            // 
            // btnGetDocProp
            // 
            this._btnGetDocProp.Location = new System.Drawing.Point(19, 61);
            this._btnGetDocProp.Name = "_btnGetDocProp";
            this._btnGetDocProp.Size = new System.Drawing.Size(174, 37);
            this._btnGetDocProp.TabIndex = 3;
            this._btnGetDocProp.Text = "Get Doc Properties";
            this._btnGetDocProp.Click += new System.EventHandler(this.btnGetDocProp_Click);
            // 
            // btnGetObjectsInRec
            // 
            this._btnGetObjectsInRec.Location = new System.Drawing.Point(19, 18);
            this._btnGetObjectsInRec.Name = "_btnGetObjectsInRec";
            this._btnGetObjectsInRec.Size = new System.Drawing.Size(174, 37);
            this._btnGetObjectsInRec.TabIndex = 2;
            this._btnGetObjectsInRec.Text = "Get Objects in Rec";
            this._btnGetObjectsInRec.Click += new System.EventHandler(this.btnGetObjectsInRec_Click);
            // 
            // tabPage9
            // 
            this._tabPage9.Controls.Add(this._btnExportToXps);
            this._tabPage9.Controls.Add(this._btnExportToTiff);
            this._tabPage9.Controls.Add(this._btnExportToRtf);
            this._tabPage9.Controls.Add(this._btnExportToJpeg);
            this._tabPage9.Controls.Add(this._btnExportToHtml);
            this._tabPage9.Controls.Add(this._btnExportToExcel);
            this._tabPage9.Location = new System.Drawing.Point(4, 46);
            this._tabPage9.Name = "_tabPage9";
            this._tabPage9.Size = new System.Drawing.Size(441, 420);
            this._tabPage9.TabIndex = 8;
            this._tabPage9.Text = "Export Modules";
            this._tabPage9.UseVisualStyleBackColor = true;
            // 
            // btnExportToXps
            // 
            this._btnExportToXps.Location = new System.Drawing.Point(10, 223);
            this._btnExportToXps.Name = "_btnExportToXps";
            this._btnExportToXps.Size = new System.Drawing.Size(174, 37);
            this._btnExportToXps.TabIndex = 7;
            this._btnExportToXps.Text = "Export to XPS";
            this._btnExportToXps.Click += new System.EventHandler(this.btnExportToXps_Click);
            // 
            // btnExportToTiff
            // 
            this._btnExportToTiff.Location = new System.Drawing.Point(10, 180);
            this._btnExportToTiff.Name = "_btnExportToTiff";
            this._btnExportToTiff.Size = new System.Drawing.Size(174, 37);
            this._btnExportToTiff.TabIndex = 6;
            this._btnExportToTiff.Text = "Export to TIFF";
            this._btnExportToTiff.Click += new System.EventHandler(this.btnExportToTiff_Click);
            // 
            // btnExportToRTF
            // 
            this._btnExportToRtf.Location = new System.Drawing.Point(10, 137);
            this._btnExportToRtf.Name = "_btnExportToRtf";
            this._btnExportToRtf.Size = new System.Drawing.Size(174, 37);
            this._btnExportToRtf.TabIndex = 5;
            this._btnExportToRtf.Text = "Export to RTF";
            this._btnExportToRtf.Click += new System.EventHandler(this.btnExportToRTF_Click);
            // 
            // btnExportToJPEG
            // 
            this._btnExportToJpeg.Location = new System.Drawing.Point(10, 95);
            this._btnExportToJpeg.Name = "_btnExportToJpeg";
            this._btnExportToJpeg.Size = new System.Drawing.Size(174, 36);
            this._btnExportToJpeg.TabIndex = 4;
            this._btnExportToJpeg.Text = "Export to JPEG";
            this._btnExportToJpeg.Click += new System.EventHandler(this.btnExportToJPEG_Click);
            // 
            // btnExportToHTML
            // 
            this._btnExportToHtml.Location = new System.Drawing.Point(10, 52);
            this._btnExportToHtml.Name = "_btnExportToHtml";
            this._btnExportToHtml.Size = new System.Drawing.Size(174, 37);
            this._btnExportToHtml.TabIndex = 3;
            this._btnExportToHtml.Text = "Export to HTML";
            this._btnExportToHtml.Click += new System.EventHandler(this.btnExportToHTML_Click);
            // 
            // btnExportToExcel
            // 
            this._btnExportToExcel.Location = new System.Drawing.Point(10, 9);
            this._btnExportToExcel.Name = "_btnExportToExcel";
            this._btnExportToExcel.Size = new System.Drawing.Size(174, 37);
            this._btnExportToExcel.TabIndex = 2;
            this._btnExportToExcel.Text = "Export to Excel";
            this._btnExportToExcel.Click += new System.EventHandler(this.btnExportToExcel_Click);
            // 
            // tabPage11
            // 
            this._tabPage11.Controls.Add(this._btnReadMetaData);
            this._tabPage11.Controls.Add(this._btnAddMetaData);
            this._tabPage11.Location = new System.Drawing.Point(4, 46);
            this._tabPage11.Name = "_tabPage11";
            this._tabPage11.Size = new System.Drawing.Size(441, 420);
            this._tabPage11.TabIndex = 10;
            this._tabPage11.Text = "MetaData";
            this._tabPage11.UseVisualStyleBackColor = true;
            // 
            // btnReadMetaData
            // 
            this._btnReadMetaData.Location = new System.Drawing.Point(18, 59);
            this._btnReadMetaData.Name = "_btnReadMetaData";
            this._btnReadMetaData.Size = new System.Drawing.Size(174, 37);
            this._btnReadMetaData.TabIndex = 1;
            this._btnReadMetaData.Text = "Read MetaData";
            this._btnReadMetaData.UseVisualStyleBackColor = true;
            this._btnReadMetaData.Click += new System.EventHandler(this.btnReadMetaData_Click);
            // 
            // btnAddMetaData
            // 
            this._btnAddMetaData.Location = new System.Drawing.Point(18, 16);
            this._btnAddMetaData.Name = "_btnAddMetaData";
            this._btnAddMetaData.Size = new System.Drawing.Size(174, 37);
            this._btnAddMetaData.TabIndex = 0;
            this._btnAddMetaData.Text = "Add MetaData";
            this._btnAddMetaData.UseVisualStyleBackColor = true;
            this._btnAddMetaData.Click += new System.EventHandler(this.btnAddMetaData_Click);
            // 
            // mainMenu1
            // 
            this._mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this._menuItem1});
            // 
            // menuItem1
            // 
            this._menuItem1.Index = 0;
            this._menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this._menuItem2,
            this._exit,
            this._menuItem3});
            this._menuItem1.Text = "File";
            // 
            // menuItem2
            // 
            this._menuItem2.Index = 0;
            this._menuItem2.Text = "";
            // 
            // Exit
            // 
            this._exit.Index = 1;
            this._exit.Text = "Exit";
            this._exit.Click += new System.EventHandler(this.Exit_Click);
            // 
            // menuItem3
            // 
            this._menuItem3.Index = 2;
            this._menuItem3.Text = "";
            // 
            // lblStatus
            // 
            this._lblStatus.AutoSize = true;
            this._lblStatus.Font = new System.Drawing.Font("Comic Sans MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this._lblStatus.ForeColor = System.Drawing.Color.Blue;
            this._lblStatus.Location = new System.Drawing.Point(732, 516);
            this._lblStatus.Name = "_lblStatus";
            this._lblStatus.Size = new System.Drawing.Size(0, 28);
            this._lblStatus.TabIndex = 6;
            // 
            // axPDF
            // 
            this._axPdf.Enabled = true;
            this._axPdf.Location = new System.Drawing.Point(25, 12);
            this._axPdf.Name = "_axPdf";
            this._axPdf.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axPDF.OcxState")));
            this._axPdf.Size = new System.Drawing.Size(797, 466);
            this._axPdf.TabIndex = 7;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
            this.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Center;
            this.ClientSize = new System.Drawing.Size(1352, 529);
            this.Controls.Add(this._axPdf);
            this.Controls.Add(this._lblStatus);
            this.Controls.Add(this._tabControl1);
            this.Menu = this._mainMenu1;
            this.Name = "Form1";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "PDF Creator Test App";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.Resize += new System.EventHandler(this.Form1_Resize);
            this._tabControl1.ResumeLayout(false);
            this._tabPage1.ResumeLayout(false);
            this._tabPage4.ResumeLayout(false);
            this._tabPage8.ResumeLayout(false);
            this._tabPage3.ResumeLayout(false);
            this._tabPage9.ResumeLayout(false);
            this._tabPage11.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._axPdf)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        private static void Main()
        {
           // Application.EnableVisualStyles();
            Application.DoEvents();
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            _axPdf.SetLicenseKey(StrLicenseTo, StrActivationCode);
            _axPdf.ScaleToWindow = acScaleConstants.acScaleBoth;

            //axPDF.ReportState = ACPDFCREACTIVEX.ReportStateConstants.acReportStateAnnotate;
            _axPdf.RulerSize = 0;

        }


        /// <summary>
        /// This method illustrates how to open a PDF document and create and add a text object onto this document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateTextObject_Click(object sender, EventArgs e)
        {


            //When set to True, the control is refreshed each time a property is modified
            _axPdf.AutoRefresh = 0;  //Set to False to reduce flicker

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            _axPdf.OpenEx(requiredPath + "\\Source_Docs\\CreateTextObject.pdf", "");
            _axPdf.ScaleToWindow = acScaleConstants.acScaleBoth;
            

            try
            {
                //Put the control in Design mode
                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                //Create a text object
                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeText, "acObjectTypeText");

                IacObject obj = _axPdf.GetObjectByName("acObjectTypeText");
                //Position the Object
                obj["Left"] = 0;
                obj["Top"] = 0;
                obj["Right"] = 3000;
                obj["Bottom"] = 1000;
                obj["BackColor"] = 192;
                obj["TextFont"] = "Arial,24,0,0,0";
                obj["Text"] = "Amyuni Tech";

                //Put the control back into run mode
                _axPdf.ReportState = ReportStateConstants.acReportStateRun;

                //save the new document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateTextObject_resulting.pdf", FileSaveOptionConstants.acFileSaveView);
                _axPdf.AutoRefresh = 1; //Set to True to render change
                
                _axPdf.Refresh();


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }


        /// <summary>
        /// This method illustrates how to draw a highlighter object
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDrawHighLighter_Click(object sender, EventArgs e)
        {
            //Put the control in Annotate Mode
             _axPdf.ReportState = ReportStateConstants.acReportStateAnnotate ;
             _axPdf.DoCommandTool(CommandToolConstants.acCommandToolHighlight);
        }


        /// <summary>
        /// This method illustrates how to create a Table object
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateTable_Click(object sender, EventArgs e)
        {
            //Put the control in design mode
            _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

            //This will create a PDF document with 4 pages
            for (int intCtr = 1; intCtr <= 4; intCtr++)
            {

                //Get one table object per page
                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeTable, "acTable" + intCtr);

                IacObject objTable = _axPdf.GetObjectByName("acTable" + intCtr);
                //position the table object on each page
                objTable["Left"] = 0;
                objTable["Top"] = 0;
                objTable["Right"] = _axPdf.PageWidth.ToString();
                objTable["Bottom"] = _axPdf.PageLength.ToString();

                //Table will consist of 20 rows and 20 columns
                objTable["Rows"] = 20;
                objTable["Columns"] = 20;

                for (int j = 1; j < 20; j++)
                {
                    IacObject objTableCell = _axPdf.GetObjectByName("acTable" + intCtr + ".Cells[" + j + "," + j + "]");

                    //This illustrates how to change attributes on particular cells
                    objTableCell["BorderWidth"] = 1;
                    objTableCell["BorderColor"] = 192;
                    objTableCell["HorzBorders"] = 3;
                    objTableCell["VertBorders"] = 3;
                    objTableCell["BackColor"] = "FF0000";

                    //This will add text to the first cell on the first table
                    _axPdf.set_ObjectAttribute("acTable1.Cells[1,1]", "Font", "Arial,40,0,0,0,0");
                    objTableCell["Text"] = intCtr.ToString() + j.ToString();
                }

                //only add upto 4 pages
                if (intCtr != 4)
                {
                    //This will add a page
                    _axPdf.AddPage(intCtr);
                }
            }

            //Put the control back into Run state
            _axPdf.ReportState = ReportStateConstants.acReportStateRun;

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            //Save resulting PDF document
            _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateTable_resulting.pdf",
                FileSaveOptionConstants.acFileSaveView);
        }


        /// <summary>
        /// This method illustrates how to add pages to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cmdCreateMultiPage_Click(object sender, EventArgs e)
        {
            try
            {
                //Create 10 pages
                for (int i = 1; i <= 10; i++)
                {
                    //Create an object with unique object name
                    _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeText, "acTextObject" + i);
                    IacObject objText = _axPdf.GetObjectByName("acTextObject" + i);

                    objText["Left"] = 0;
                    objText["Top"] = 0;
                    objText["Right"] = 1500;
                    objText["Bottom"] = 1000;
                    objText["TextFont"] = "Arial,40,0,0,0";
                    objText["Text"] = "Page: " + i;

                    if (i != 10)
                    {
                        _axPdf.AddPage(i);
                    }
                  }

                //Put the control back into Run state
                _axPdf.ReportState = ReportStateConstants.acReportStateRun;

                //get startup path for temp working files
                var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                        Path.GetDirectoryName(
                                                        Assembly.GetExecutingAssembly().Location))));
                //Save resulting PDF document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateMultiPage_resulting.pdf", 
                                                  FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The GetObjectsInRectangle method gets all the objects that are in the specified rectangle. The objects are placed in
         ///a Safe Array.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetObjectsInRec_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));
            try
            {
                _axPdf.Open(requiredPath + "Source_Docs\\CreateTextObject.pdf", "");

               //Get array of objects
               IacObject[] myObjArray
                    = (IacObject[])_axPdf.GetObjectsInRectangle(0, 0, 10000, 12000, 0);

               foreach (IacObject obj in myObjArray)
               {
                   //Check if it is a text object
                   if (!obj["ObjectType"].Equals(5)) continue;
                   if (obj["Text"] == null)
                    {
                        continue;
                    }

                    obj.Coordinates(out var l, out var t, out var r, out var b);

                   //The DelimitedText method returns part of the text enclosed in a rectangle.
                   MessageBox.Show(obj.DelimitedText(l, t, r, b));

                   //text property is not empty and exist
               }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how to rotate a page
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRotatePage_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");
              
                //This rotates page 1
                _axPdf.RotatePage(1, RotatePageConstants.acRotatePageLeft);

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\RotatePage_resulting.pdf",
                                   FileSaveOptionConstants.acFileSaveAll);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The Print method is used to print the document to a specified printer.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrint_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                 _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");

                //Parameters
                    //PrinterName
                        //If no printer name is specified, the document is printed to the default printer.
                    //Prompt
                        //If this parameter is set to True, the user is prompted with the printer selection dialog box.
                 _axPdf.Print("", 1);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how to use the StartSave() method. 
        /// The StartSave() method is used to start page by page saving of a document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSavePage_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                //axPDF.OpenEx(System.IO.Directory.GetCurrentDirectory() + "\\temp.pdf", "");
                _axPdf.Open(requiredPath + "Source_Docs\\tenpages.pdf", "");

                _axPdf.StartSave(requiredPath + "Resulting_Docs\\SavePage_resulting.pdf", 
                                                   FileSaveOptionConstants.acFileSaveView); 

                //This example saves pages 1 and 4 to new PDF document
                _axPdf.SavePage(1);
                _axPdf.SavePage (4);

                /*' Save only from page 6 to page 10
                For n = startSave To endSave
                .SavePage n
                Next */

                _axPdf.Modified = 0;
                _axPdf.EndSave();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    

        /// <summary>
        /// This method illustrates how to clear the control
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnInitControl_Click(object sender, EventArgs e)
        {
            _axPdf.InitBlank();
            _axPdf.Refresh();
        }




        /// <summary>
        /// The EmbedFont sets font embedding option for specific fonts.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEmbedFonts_Click(object sender, EventArgs e)
        {
            /* Font Options
            acEmbedFontOptionDefault = -1 (&HFFFFFFFF)
            acEmbedFontOptionFull = 2
            acEmbedFontOptionNoEmbed = 0
            acEmbedFontOptionPartial = 1
            */

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");
                _axPdf.EmbedFont("Courier New", acEmbedFontOptions.acEmbedFontOptionFull);

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\EmbedFonts_resulting.pdf", 
                                  FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

 

        /// <summary>
        /// The Undo method is used to undo the latest action.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnUnDo_Click(object sender, EventArgs e)
        {
            try
            {
                _axPdf.DeleteObject("acTextObject", 1);

                //Read undo levels
                MessageBox.Show(_axPdf.UndoLevels().ToString());

                //undo last action			
                _axPdf.Undo();

                //Read undo levels
                MessageBox.Show(_axPdf.UndoLevels().ToString());

                //axPDF.Refresh ();;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The Redo method is used to redo the latest undone action.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnReDo_Click(object sender, EventArgs e)
        {
            try
            {
                _axPdf.DeleteObject("acTextObject", 1);

                //Read undo levels
                MessageBox.Show(_axPdf.UndoLevels().ToString());

                //undo last action			
                _axPdf.Undo();

                //Read number of redo levels
                MessageBox.Show(_axPdf.RedoLevels().ToString());

                //Redo latest undone action		
                _axPdf.Redo();

                //Read number of redo levels
                MessageBox.Show(_axPdf.RedoLevels().ToString());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        /// <summary>
        /// The RedrawObject method redraws the object referenced by Object. This can be called after changing the objects
        /// properties to refresh the object.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRedrawObject_Click(object sender, EventArgs e)
        {
            try
            {
                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeFrame, "acTypeFrame");
                IacObject objFrame = _axPdf.GetObjectByName("acTypeFrame");

                objFrame["Left"] = 200;
                objFrame["Top"] = 200;
                objFrame["Right"] = 600;
                objFrame["Bottom"] = 400;

                //refresh the object when all its properties have been defined
                _axPdf.RedrawObject("acTypeFrame");

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// The ScrollWindow method can be used to scroll the document window by HorzScroll and VertScroll increments.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnScrollWindow_Click(object sender, EventArgs e)
        {
            //Scroll the document window by HorzScroll and VertScroll increments
            _axPdf.ScrollWindow (100, (_axPdf.PageLength / 2 ));

            //Parameters
            //HorzScroll
            //  The amount to scroll horizontally in twips
            //VertScroll
            //  The amount to scroll vertically in twips
            //scroll horizontally and vertically
            _axPdf.ScrollWindow (100, 7000);
        }



        /// <summary>
        /// This method illustrates how to use the ReachText() method which searches for text in a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnReachText_Click(object sender, EventArgs e)
        {

            /*===============================================================
            'Parameters:
            'Option
            '-1 case sensitive search from the beginning of the document
            '0 case sensitive search from current position
            '1 search from the beginning of the document, case-insensitive
            '2 search from the current position, case-insensitive

            'Text Text to search for
            'FontName If provided (not empty), the text has to be in the specified font
            'FontSize If provided (not 0), the text has to be in the specified font size
            'Bold, Italic The text has to be in the specified font style
            ===============================================================*/

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");

                var intFoundIt = _axPdf.ReachText(ReachTextOptionConstants.acReachTextOptionCurrent
                    , "change"
                    , "", 0, 0, 0);

                MessageBox.Show(intFoundIt == 0 ? "Didn't find it!" : "Found it!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// This method illustrates how to use the MovePages method. 
        /// The MovePages method moves one or more pages to another location within the document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMovePages_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "Source_Docs\\tenpages.pdf", "");
                
                /*
                 Parameters
                 ---------
                    PageNumber
                            Starting page
                    PageCount
                        Number of pages to move
                    Destination
                        Where to place the moved pages
                */
                _axPdf.MovePages(2, 1, 4);

                _axPdf.Save(requiredPath + "Resulting_Docs\\MovePages_resulting.pdf", 
                    FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The DeletePage method deletes the page at a specified location.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDeletePage_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "Source_Docs\\tenpages.pdf", "");

                //DeletePage ( int pagenumber , canundo)
                _axPdf.DeletePage(2, 0);

                //Set modified flag to false
                //do not regenerate the document
                _axPdf.Modified = 0;

                _axPdf.Save(requiredPath + "Resulting_Docs\\DeletePage_resulting.pdf",
                FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The DuplicatePage method duplicates the current page and adds it at a specified position. This method creates a
        ///copy of the current page with all its contents and places this copy at the position specified by PageIndex.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDuplicatePages_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "Source_Docs\\tenpages.pdf", "");

                //DuplicatePage ( int pageindex ) uses zero based index
                //Must set control to current page
                _axPdf.CurrentPage = 2;
                _axPdf.DuplicatePage(4);

                _axPdf.Save(requiredPath + "Resulting_Docs\\DuplicatePages_resulting.pdf",
                FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// The MergeEx method merges the contents of the current document into a specified PDF file.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMerge_Click(object sender, EventArgs e)
        {

            /*===============================================================
            'Option                     Option Value    Description
            'Repeat first pages             1          The first pages of the second document are repeated in the first Document
            'Second document above First    2          The contents of the second document are printed above the contents the first document
            ===============================================================*/

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.OpenEx(requiredPath + "\\Source_Docs\\logo.pdf", "");
                _axPdf.Merge(requiredPath + "\\Source_Docs\\text.pdf", "", 2);

                //save the new document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\Merge_resulting.pdf",
                                            FileSaveOptionConstants.acFileSaveView);

                _axPdf.Refresh();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// The ExportToExcel method is used to export a PDF document to Excel format. It is recommended to use this method
        ///together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToExcel_Click(object sender, EventArgs e)
        {
            /*===============================================================
            '    Optimization Level OptimizeLevel value
            '    No optimization 0
            '    Line optimization (Recommended) 1
            '    Paragraph optimization 2

                'optimize document to line level before exporting
                .OptimizeDocument 1
			        
			
            Export Constants
            'acExcelExportDecimalSeparator_Comma = 2
            'acExcelExportOptionMultipleSheets = 1
            'acExcelExportOptionSingleSheet = 0
            ===============================================================*/

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
  
                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");
               
                _axPdf.OptimizeDocument(1);
                _axPdf.ExportToExcel(requiredPath + "\\Resulting_Docs\\ExportToExcel_resulting.xls",
                    acExcelExportOptions.acExcelExportOptionMultipleSheets);

                MessageBox.Show ( "Export to XLS Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The ExportToHTML method is used to export a PDF document to HTML format. It is recommended to use this method
        ///together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToHTML_Click(object sender, EventArgs e)
        {
            /*===============================================================
            ' The text inside a PDF file is usually split into multiple parts,
            ' a single sentence or paragraph can consist of multiple pieces of text
            ' positioned independently inside the PDF document. The Optimize method
            ' attempts to regroup lines or paragraphs prior to exporting the PDF file
            ' into another format, or to make the file easier to edit.
			
            ' No optimization = 0
            ' Line optimization (Recommended) = 1
            ' Paragraph optimization = 2
			        
			
            HTML Constants
            acHtmlExportOptionLayers = 1
            acHtmlExportOptionMultiplePages = 3
            acHtmlExportOptionSinglePage = 2
            ===============================================================*/

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));
            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                _axPdf.OptimizeDocument(1);

                _axPdf.ExportToHTML(requiredPath + "\\Resulting_Docs\\ExportToHTML_resulting.html",
                    acHtmlExportOptions.acHtmlExportOptionMultiplePages);

               MessageBox.Show ("Export to HTML Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// The ExportToJPeg method is used to export a PDF document to multiple JPEG files. It is recommended to use this
        ///method together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToJPEG_Click(object sender, EventArgs e)
        {
            /*===============================================================
                ' The text inside a PDF file is usually split into multiple parts,
                ' a single sentence or paragraph can consist of multiple pieces of text
                ' positioned independently inside the PDF document. The Optimize method
                ' attempts to regroup lines or paragraphs prior to exporting the PDF file
                ' into another format, or to make the file easier to edit.
			
                ' No optimization = 0
                ' Line optimization (Recommended) = 1
                ' Paragraph optimization = 2
			        
			
                JPEG Constants
                FileName
                    name of the file with .jpg extension to export to.
                Resolution
                    72, 150, 300, 600
                JPegLevel
                    from 1 (highest) to 9 (lowest) in the low order word
                ===============================================================*/
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                _axPdf.OptimizeDocument(1);

                _axPdf.ExportToJPeg(requiredPath + "\\Resulting_Docs\\ExportToJPEG_resulting.jpg", 300, 3);
                MessageBox.Show ( "Export to JEPG Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// The ExportToRTF method is used to export a PDF document to RTF format. It is recommended to use this method
        ///together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToRTF_Click(object sender, EventArgs e)
        {

            /*===============================================================
                ' The text inside a PDF file is usually split into multiple parts,
                ' a single sentence or paragraph can consist of multiple pieces of text
                ' positioned independently inside the PDF document. The Optimize method
                ' attempts to regroup lines or paragraphs prior to exporting the PDF file
                ' into another format, or to make the file easier to edit.
			
                ' No optimization = 0
                ' Line optimization (Recommended) = 1
                ' Paragraph optimization = 2
			        
            FileName
                name of the file with .rtf extension to export to.
            Options
                Option							Value	Description
                acRtfExportOptionAdvancedRTF	0		Advanced RTF: using frames to position objects
                acRtfExportOptionFullRTF		1		Full RTF: Text, Graphics and images with no frames
                acRtfExportOptionRTFText		2		Formatted Text only
                acRtfExportOptionText			3		Simple text, non-formatted
            UseTabs
                Set this parameter True to enable tabs in the document, False (or 0) to replace tabs with spaces (Effective
                only for non-formatted simple text).
                ===============================================================*/
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                _axPdf.OptimizeDocument(1);

                _axPdf.ExportToRTF(requiredPath + "\\Resulting_Docs\\ExportToRTF_resulting.rtf",
                    acRtfExportOptions.acRtfExportOptionAdvancedRTF, 0);
                MessageBox.Show ( "Export to RTF Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// The GetWarningLevel method is used to read any warnings generated when opening a document. The warnings are
        ///related to features not supported by the PDF Creator.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetWarningLevel_Click(object sender, EventArgs e)
        {
            /*
             The GetWarningLevel function is used to read any warnings generated when opening the document 
             */
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "Source_Docs\\tenpages.pdf", "");
                MessageBox.Show(_axPdf.GetWarningLevel().ToString());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// This method illustrates how to retrieve current active tool
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnActiveTool_Click(object sender, EventArgs e)
        {

            /*
             The ActiveTool function returns the tool that is currently active in the view 
             */
            _axPdf.ReportState = ReportStateConstants.acReportStateAnnotate;

            //in this example, we are using the acObjectTypeHighlight object
            _axPdf.InsertObject(ObjectTypeConstants.acObjectTypeHighlight);

            MessageBox.Show(_axPdf.ActiveTool().ToString());
        }



        /// <summary>
        /// The MergeEx method merges the contents of the current document into a specified PDF file.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMergeEx_Click(object sender, EventArgs e)
        {
            /*===============================================================
            'Option                     Option Value    Description
            'Repeat first pages             1          The first pages of the second document are repeated in the first Document
            'Second document above First    2           The contents of the second document are printed above the contents the first document
            ===============================================================*/

            //open first file in new object
            PDFCreactiveXClass pdf2 = new PDFCreactiveXClass();
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            pdf2.SetLicenseKey(StrLicenseTo, StrActivationCode);
            pdf2.Open(requiredPath + "\\Source_Docs\\a.pdf", "");

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

                _axPdf.MergeEx(pdf2, 1);
                _axPdf.Refresh();
                _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\MergeEx_resulting.pdf",
                            FileSaveOptionConstants.acFileSaveView);               
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }





        // The AppendEx method can be used to append or concatenate a PDF file to the current document. Whenever possible,
        // it is recommended to call the Append method rather than the AppendEx method. The Append method is usually
        // more efficient.
        private void btnAppendEx_Click(object sender, EventArgs e)
        {
            //open a document to append using another instance of PDF Creator Control
            PDFCreactiveXClass pdf2 = new PDFCreactiveXClass();
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            pdf2.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\a.pdf", "");              

                //append PDF2 document to the current document
                _axPdf.AppendEx(pdf2);

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\AppendEx_resulting.pdf",
                            FileSaveOptionConstants.acFileSaveView);       
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// This method illustrates how to use the SelectAllObjects() 
        /// method to change the text attribute and value on all objects on a page
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetAttributeForMultipleSelection_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\objects.pdf", "");

                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                //The SelectAllObjects method selects/unselects all objects on the current page.
                //Set SelectAllObjects to true
                _axPdf.SelectAllObjects(1);

                _axPdf.SetAttributeForMultipleSelection("TextFont", "Courier New,14,700,0,0");
                _axPdf.SetAttributeForMultipleSelection("Text", "new values added");

                _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\SetAttributeForMultipleSelection_resulting.pdf",
                           FileSaveOptionConstants.acFileSaveAll);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The LockAllObjects method is used to lock/unlock all objects on the current page.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnLockAllObjects_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeText, "acTextObject");
                IacObject objText = _axPdf.GetObjectByName("acTextObject");

                objText["Text"] = "This is a text object";
                objText["Left"] = 0;
                objText["Top"] = 0;
                objText["Right"] = 1500;
                objText["Bottom"] = 200;
                objText["BackColor"] = "00AA00";

                _axPdf.ReportState = ReportStateConstants.acReportStateRun;

                //Set this parameter True (or 1) to lock, False (or 0) to unlock.
                _axPdf.LockAllObjects(1);

                //save the new document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\LockAllObjects_resulting.pdf", 
                                               FileSaveOptionConstants.acFileSaveView); 
             }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }



        /// <summary>
        /// This method illustrates how to create Checkboxes
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateCheckButton_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));
            try
            {
                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeCheckBox, "CheckBox");
                IacObject objCheckBox = _axPdf.GetObjectByName("CheckBox");

                //Position object
                objCheckBox["Top"] = 1000;
                objCheckBox["Left"] = 1000;
                objCheckBox["Right"] = 1500;
                objCheckBox["Bottom"] = 1700;
                objCheckBox["BorderWidth"] = 1;

                /*
                    0: acCheckBox
                    1: acPushButton
                    2: acRadioButton
                 */

                objCheckBox["ButtonType"] = 0;

                //button is checked
                objCheckBox["Text"] = "On";

                _axPdf.ReportState = ReportStateConstants.acReportStateRun;

                //save the new document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateCheckButton_resulting.pdf", 
                                               FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }

        public string SaveFile(bool bStatusValue, string strFileName)
        {
            string strSaveStatus;

            if (bStatusValue)
            {
                strSaveStatus = "acFileSaveView";
                _axPdf.Save(Directory.GetCurrentDirectory() + "\\temp\\" + strFileName + "_test_" + strSaveStatus + ".pdf", FileSaveOptionConstants.acFileSaveView);

            }
            else
            {
                strSaveStatus = "acFileSaveAll";
                _axPdf.Save(Directory.GetCurrentDirectory() + "\\temp\\" + strFileName + "_test_" + strSaveStatus + ".pdf", FileSaveOptionConstants.acFileSaveAll);
            }

            return Directory.GetCurrentDirectory() + "\\temp\\" + strFileName + "_test_" + strSaveStatus + ".pdf";
        }



        /// <summary>
        /// The SetPageNumbering method enables the developer to automatically number all pages of a document. Page
        ///numbers are automatically adjusted when pages are added, removed or moved within the document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPageNumber_Click(object sender, EventArgs e)
        {

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
		    {
                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");
                _axPdf.SetPageNumbering(acPageNumbersPositions.acPageNumbersPositionTopCenter, 
				    "Verdana,24,700,0,0", 
				    0, 
				    0, 
				    192, 
				    1, 
				    "- Page #page of #pages -" );

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\PageNumber_resulting.pdf",
                             FileSaveOptionConstants.acFileSaveAll);

                _axPdf.Refresh();
    		}
		    catch(Exception ex)
		    {
			    MessageBox.Show (ex.Message);
		    }
        }


        /// <summary>
        /// This method illustrates how to retrieve the document properties of a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetDocProp_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\GetDocProp.pdf", "");

                MessageBox.Show(_axPdf.get_ObjectAttribute("Document", "Author").ToString(), "Author");
                MessageBox.Show(_axPdf.get_ObjectAttribute("Document", "Creator").ToString(), "Creator");
                MessageBox.Show ( _axPdf.get_ObjectAttribute ("Document", "Producer").ToString(), "Producer");
                MessageBox.Show ( _axPdf.get_ObjectAttribute ("Document", "Subject").ToString(), "Subject"); 
                MessageBox.Show(_axPdf.get_ObjectAttribute("Document", "Title").ToString(), "Title");
            }                
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

   

        /// <summary>
        /// The DigitalSignature method is used to add a digital signature to a PDF document. Prior to digitally signing a
        ///document, the users or developers should have on their systems a digital certificate that can be used to sign
        ///documents. A user who receives a document that is digitally signed can verify if the digital signature is valid and if the
        ///document has been tempered with.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDigitalSignatures_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");
  
                /*	Signer name			1
                    Reason for signing	2
                    Location			4
                    Associated image	8
                    Date of signing		32
                    Signature type		64
                */

                _axPdf.DigitalSignature(
                    "Bob",
                    "my reason",
                    requiredPath + "\\Source_Docs\\sign.jpg",
                    "Loaction",
                    1, 0, 0, 800, 800,
                    101); // 1 + 2 + 4 + 8 + 32 + 64 );

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\DigitalSignatures_resulting.pdf",
                             FileSaveOptionConstants.acFileSaveAll);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The AutoHyperlinks method automatically converts text in the document that contains 
        /// hyperlinks into active hyperlinks that can be clicked.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAutoHyperlinks_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                    _axPdf.Open(requiredPath + "\\Source_Docs\\createhyperlinks.pdf", "");

                    _axPdf.ReportState = ReportStateConstants.acReportStateDesign;
                    _axPdf.AutoHyperlinks("http://;mailto:");

                    _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

                    _axPdf.Save(requiredPath + "\\Resulting_Docs\\AutoHyperlinks_resulting.pdf", 
                                                       FileSaveOptionConstants.acFileSaveView);             
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




        /// <summary>
        /// The ExportToTiff method is used to export a PDF document to a single TIFF file. It is recommended to use this
        ///method together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToTiff_Click(object sender, EventArgs e)
        {
            /*===============================================================
                    ' The text inside a PDF file is usually split into multiple parts,
                    ' a single sentence or paragraph can consist of multiple pieces of text
                    ' positioned independently inside the PDF document. The Optimize method
                    ' attempts to regroup lines or paragraphs prior to exporting the PDF file
                    ' into another format, or to make the file easier to edit.

                    ' No optimization = 0
                    ' Line optimization (Recommended) = 1
                    ' Paragraph optimization = 2
						
                FileName
                    name of the file with .tif extension to export to.
						
                Resolution
                72, 150, 300, 600

                Options

                0 = represents no compression
                1 to 9 = represents the Jpeg Compression level to use. Note: This not supported by all TIFF viewers
                10 = represents CCITT fax compression
				
                axPDF.OptimizeDocument = 1;
					
                All other values reserved for future use
            ===============================================================*/
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                _axPdf.ExportToTiff(requiredPath + "\\Resulting_Docs\\ExportToTiff_resulting.tif", 300, 10);
                MessageBox.Show ( "Export to TIFF Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


  


        /// <summary>
        /// This method illustrates how to retrieve the value of a field object in a PDF document. 
        /// This is typically used to retrieve values from form data
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetTextValue_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            _axPdf.OpenEx(requiredPath + "\\Source_Docs\\CreateTextObject.pdf", "");        
            
            try
            {
                //Get array of objects
                IacObject[] myObjArray
                    = (IacObject[])_axPdf.get_ObjectAttribute("Pages[1]", "Objects");

                foreach (var o in myObjArray)
                {
                    var obj = (acObject) o;
                    //Check if it is a field object
                    if (obj["ObjectType"].Equals(6))
                    {
                        MessageBox.Show("acObjectTypeField found", "Amyuni PDF Creator");

                        //text property is not empty and exist
                        if (obj["Text"] != null)
                        {
                            //Retrieve text value
                            MessageBox.Show(obj["Text"].ToString());
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The DeleteObject method can be used to delete an object referenced by the Object parameter from the PDF
        ///document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDeleteObject_Click_1(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                
                _axPdf.OpenEx(requiredPath + "\\Source_Docs\\stickynote.pdf", "");

                //Get array of objects
                IacObject[] myObjArray
                    = (IacObject[])_axPdf.get_ObjectAttribute("Pages[1]", "Objects");

                foreach (IacObject obj in myObjArray)
                {
                    //Check if object is a Picture object
                    if (obj["ObjectType"].Equals(22))
                    {
                        /*Parameters
                            Object
                                An object name to delete
                            CanUndo
                                This parameter should be set to True if the user is allowed to undo the delete object action. This is usually
                                the case when this method is called from a menu or other user interface. This parameter should be set to
                                False if the user cannot undo this action; this is more efficient and avoids the overhead related to
                                managing the Undo list.
                         */
                        _axPdf.DeleteObject(obj["Name"].ToString(), 0);
                    }
                }

                //save the new document
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\DeleteObject_resulting.pdf",
                                            FileSaveOptionConstants.acFileSaveView);       
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        private void Exit_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }




        /// <summary>
        /// This code snippet illustrates how to extract contents of a PDF document using an object name
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRetreiveTextValue_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice_filled.pdf", "");

                //Retrieve values based on object names
                MessageBox.Show(_axPdf.get_ObjectAttribute("BILLTO", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("SHIPTO", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("SALESPERSON", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("PONUMBER", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("SHIPDATE", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("ITEM1_QTY", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("ITEM1_DESC", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("ITEM1_UNIT_PRICE", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("ITEM1_AMOUNT", "Text").ToString());
                MessageBox.Show(_axPdf.get_ObjectAttribute("TOTAL", "Text").ToString());    
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how to insert a PDF document at the beginning of another document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnInsertPDFBegin_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            int iPageCount;
            int iNewPageCount;

            string strAppendFileName = requiredPath + "\\Source_Docs\\a.pdf";
            string strNewAppendedFileName = requiredPath + "\\Resulting_Docs\\InsertPDFBegin_resulting.pdf";

            try
            {
                //Open a (example) 10 page document to insert document into
                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");
   
                //get total number of pages in current doc
                iPageCount = _axPdf.PageCount;

                //append and save file
                _axPdf.Append(strAppendFileName, "");
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);

                //open newly appended document 
                _axPdf.Open(strNewAppendedFileName, "");

                //get new page count
                iNewPageCount = _axPdf.PageCount;

                //Move pages to correct locations (beginning)
                _axPdf.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), 1);

                //save file
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how to insert a PDF document at the end of another document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnInsertPDFatEnd_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

            _axPdf.AutoRefresh = 0;

            _axPdf.Append(requiredPath + "\\Source_Docs\\a.pdf", "");

            //save file
            _axPdf.Save(requiredPath + "\\Resulting_Docs\\InsertPDFatEnd_resulting.pdf", 
                                   FileSaveOptionConstants.acFileSaveView);

            _axPdf.Refresh();  //I needed to add this to refresh control
            _axPdf.AutoRefresh = 1;
        }



        /// <summary>
        /// This method illustrates how to insert a PDF document before the current page that is being rendered on the PDF Creator control.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnInsertBeforeCurrentPage_Click(object sender, EventArgs e)
        {
            int iPageCount;
            int iCurrentPage;
            int iNewPageCount;

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            string strAppendFileName = requiredPath + "\\Source_Docs\\a.pdf";
            string strNewAppendedFileName = requiredPath + "\\Resulting_Docs\\InsertBeforeCurrentPage_resulting.pdf";

            try
            {
               _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

                _axPdf.AutoRefresh = 0;

                //to go page 4
                _axPdf.CurrentPage = 4;
                _axPdf.Refresh();

                //get current page value
                iCurrentPage = _axPdf.CurrentPage;

                //get total number of pages in current doc
                iPageCount = _axPdf.PageCount;

                //append and save file
                _axPdf.Append(strAppendFileName, "");
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);

                //open newly appended document 
                _axPdf.Open(strNewAppendedFileName, "");

                //get new page count
                iNewPageCount = _axPdf.PageCount;

                //Move pages to correct locations (beginning)
                _axPdf.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), iCurrentPage);

                //save file
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);

                _axPdf.Refresh();
                _axPdf.AutoRefresh = 1;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how to insert a PDF document after the current page that is being rendered on the PDF Creator control.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnInsertAfterTheCurrentPage_Click(object sender, EventArgs e)
        {
            int iPageCount;
            int iCurrentPage;
            int iNewPageCount;


            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            string strAppendFileName = requiredPath + "\\Source_Docs\\a.pdf";
            string strNewAppendedFileName = requiredPath + "\\Resulting_Docs\\InsertBeforeCurrentPage_resulting.pdf";

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

                _axPdf.CurrentPage = 4;
                _axPdf.Refresh();

                //get current page value
                iCurrentPage = _axPdf.CurrentPage;

                //get total number of pages in current doc
                iPageCount = _axPdf.PageCount;

                //append and save file
                _axPdf.Append(strAppendFileName, "");
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);

                //open newly appended document 
                _axPdf.Open(strNewAppendedFileName, "");

                //get new page count
                iNewPageCount = _axPdf.PageCount;

                //Move pages to correct locations (beginning)
                _axPdf.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), (iCurrentPage + 1));

                //save file
                _axPdf.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The Encrypt method secures the PDF document and prevents it from unauthorized access. Two passwords, the owner
        /// password and user password, are associated to an encrypted PDF document.
        /// This feature is only available in the version of the PDF Creator bundled with the Amyuni PDF Suite
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEncrypt_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
               _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");
           

                /*
                  A blank password:
                 -----------------
                 The user is not prompted for a password when opening a
                 document, but is restricted to the operations allowed by the
                 author.*

                 The same password as the owner:
                 -------------------------------
                 The user is prompted for a password and the author of the
                 document will not be able to open this document as an owner
                 to change its security settings.

                 A password different from the owner:
                 ------------------------------------
                 The user will not be able to open the document unless he/she
                 enters a valid password. When a valid password is entered,
                 the document can be viewed but its usage restricted to the
                 operations allowed by the author.
                 */

                //axPDF.Encrypt("aaaaaa", "", -64);
                _axPdf.Encrypt128("aaaaaa", "", -64);

                //save file
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\Encrypt_resulting.pdf",
                                       FileSaveOptionConstants.acFileSaveView);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

     


        /// <summary>
        /// This method will trigger the SavePage event to fire
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSavePageEvent_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));


            try
            {
               _axPdf.OpenEx(requiredPath + "\\Source_Docs\\tenpages.pdf", "");

                //save file
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\SavePageEvent_resulting.pdf",
                                       FileSaveOptionConstants.acFileSaveView);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// The event LoadPage is fired when opening a document and before each page is loaded.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_LoadPage(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_LoadPageEvent e)
        {
            //MessageBox.Show ( axPDF.CurrentPage.ToString ()); 
        }



        /// <summary>
        /// This code snippet illustrates how to populate the contents of a PDF document using an object name. 
        /// This is typically used to fill form fields
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetTextValue_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");
         

                _axPdf.set_ObjectAttribute("BILLTO", "Text", "Company Co." + Environment.NewLine +
                                                             "1234 Amywhere St." + Environment.NewLine +
                                                             "City, State" + Environment.NewLine +
                                                             "USA");

                _axPdf.set_ObjectAttribute("SHIPTO", "Text", "Company Co." + Environment.NewLine +
                                             "9999 Street St." + Environment.NewLine +
                                             "City, State" + Environment.NewLine +
                                             "USA");

                _axPdf.set_ObjectAttribute("SALESPERSON", "Text", "John Smith");
                _axPdf.set_ObjectAttribute("PONUMBER", "Text", "111-000-11");
                _axPdf.set_ObjectAttribute("SHIPDATE", "Text", "Jan 1, 2012");
                _axPdf.set_ObjectAttribute("ITEM1_QTY", "Text", "99");
                _axPdf.set_ObjectAttribute("ITEM1_DESC", "Text", "New Widgets");
                _axPdf.set_ObjectAttribute("ITEM1_UNIT_PRICE", "Text", "1.00");
                _axPdf.set_ObjectAttribute("ITEM1_AMOUNT", "Text", "99.00");
                _axPdf.set_ObjectAttribute("TOTAL", "Text", "99.00");
 
                _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

                
                _axPdf.Save(requiredPath + "\\Resulting_Docs\\acFileSaveAll.pdf", 
                                    FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

       
   

        /// <summary>
        /// The MouseUp event is fired whenever the mouse button is released.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_MouseUpEvent(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_MouseUpEvent e)
        {
            /*MessageBox.Show ("axPDF_Leave"); 
            ControlCollection cc;
            cc = (ControlCollection)this.Controls;

            foreach (Control ctrl in cc)
            {
                ctrl.TabStop = true;
            } */
        }


        /// <summary>
        /// This method illustrates how to insert an image into a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreatePicObject_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));


            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");
                _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

                _axPdf.CreateObject(ObjectTypeConstants.acObjectTypePicture, "ObjectTypePicture");
                IacObject objTypePicture = _axPdf.GetObjectByName("ObjectTypePicture");

                //Position Object
                objTypePicture["Left"] = 0;
                objTypePicture["Top"] = 0;
                objTypePicture["Right"] = _axPdf.PageWidth;
                objTypePicture["Bottom"] = _axPdf.PageLength;
                objTypePicture["FileName"] = requiredPath + "\\Source_Docs\\demo_logo.jpg";

                //This will add the image in the background
                //select the object
                objTypePicture.Selected = 1;

                //apply changes
                _axPdf.DoCommandTool(CommandToolConstants.acCommandToolBringBackward);
 
                _axPdf.ReportState = ReportStateConstants.acReportStateRun;

               _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreatePicObject_resulting.pdf", 
                                               FileSaveOptionConstants.acFileSaveView); 
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This method illustrates how use the COM object
        /// In this method only pages 5 and 8 are being saved to a new file
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSaveCloseLib_Click(object sender, EventArgs e)
        {
            PDFCreactiveXClass pdf = new PDFCreactiveXClass();

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                pdf.OpenEx(requiredPath + "\\Source_Docs\\tenpages.pdf", "");
                pdf.SetLicenseKey(StrLicenseTo, StrActivationCode);

                pdf.StartSave(requiredPath + "\\Resulting_Docs\\SaveCloseLib_resulting.pdf", 
                                             FileSaveOptionConstants.acFileSaveView);
                pdf.SavePage(5);
                pdf.SavePage(8);
                pdf.EndSave();


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



   

        /// <summary>
        /// This method illustrates how to create and add bookmarks to existing PDF documents
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateBookmarks_Click(object sender, EventArgs e)
        {
            //Create bookmark objects
            var acBookmarkClass = new acBookmarkClass();

            try
            {
                //get startup path for temp working files
                var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                        Path.GetDirectoryName(
                                                        Assembly.GetExecutingAssembly().Location))));

                _axPdf.Open(requiredPath + "\\Source_Docs\\tenpages.pdf", "");


                //When set to True, the control is refreshed each time a property is modified
                _axPdf.AutoRefresh = 0;  //Set to False to reduce flicker

                //create a rootbook mark object
                var acBookRoot = _axPdf.RootBookmark;
                acBookRoot.InsertChild(1, "This is a bookmark", "", out var acBookChild);

                _axPdf.CurrentPage = 1;

                int intPageCtr = _axPdf.PageCount;

                for (int iCtr = 1; iCtr <= intPageCtr; iCtr++)
                {
                    _axPdf.CurrentPage = iCtr;
                    acBookChild.InsertChild(iCtr, "Bookmark on Page: " + iCtr, "", out _);
                }

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateBookmarks_resulting.pdf", 
                                                FileSaveOptionConstants.acFileSaveView);

                //TThe Bookmark objects ReachBookmark method displays the 
                //document location pointed to by that bookmark.
                _axPdf.ReachBookmark("Bookmark on Page: 9");
                _axPdf.Refresh();  //
                _axPdf.AutoRefresh = 1;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// This method illustrates how to draw an Arrow object on to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateArrow_Click(object sender, EventArgs e)
        {
            _axPdf.DoCommandTool(CommandToolConstants.acCommandToolArrow);
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
        }

        private void btnCreateStickyNote_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            //When set to True, the control is refreshed each time a property is modified
            _axPdf.AutoRefresh = 0;  //Set to False to reduce flicker

            //Open PDF document			
            _axPdf.Open(requiredPath + "\\Source_Docs\\text.pdf", "");
            _axPdf.ScaleToWindow = acScaleConstants.acScaleBoth;

            //Put document in Annoation State
            //This will allow you to add annotations without your users have 
            //the ability to edit the PDF document beign viewed
            _axPdf.ReportState = ReportStateConstants.acReportStateAnnotate;

            //Create Annation
            _axPdf.CreateObject(ObjectTypeConstants.acObjectTypeStickyNote, "StickyNote");
            IacObject objStickyNote = _axPdf.GetObjectByName("StickyNote");

            //Position Object
            objStickyNote["Note Top"] = 1000;
            objStickyNote["Note Left"] = 1000;
            objStickyNote["Note Right"] = 5000;
            objStickyNote["Note Bottom"] = 5000;

            objStickyNote["Icon Top"] = 950;
            objStickyNote["Icon Left"] = 1000;
            objStickyNote["Icon Right"] = 1300;
            objStickyNote["Icon Bottom"] = 1250;

            objStickyNote["Open"] = true;
            objStickyNote["Text"] = "Amyuni Tech";

            //Apply changes
            _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

            //save the new document
            _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreateStickyNote_resulting.pdf", 
                                        FileSaveOptionConstants.acFileSaveView);
          
            _axPdf.AutoRefresh = 1; //Set to True to render change
            _axPdf.Refresh();
        }


        /// <summary>
        /// This method illustrates how to Load an image object from a stream
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnLoadPicFile_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            //When set to True, the control is refreshed each time a property is modified
            _axPdf.AutoRefresh = 0;  //Set to False to reduce flicker

            int bpc = 0;
            _axPdf.ZoomFactor = 140;
            _axPdf.ReportState = ReportStateConstants.acReportStateDesign;

            // Create a new bitmap.
            // Or get one from an already created Stream
            Bitmap bmp = new Bitmap(requiredPath + "\\Source_Docs\\benchmark_chart.jpg");
            _axPdf.ScaleToWindow = acScaleConstants.acScaleBoth;

            //create Picture Object
            _axPdf.CreateObject(ObjectTypeConstants.acObjectTypePicture, "imageno");
            IacObject objTypePicture = _axPdf.GetObjectByName("imageno");

            switch (bmp.PixelFormat)
            {
                case System.Drawing.Imaging.PixelFormat.Format24bppRgb:
                    bpc = 24;
                    break;

                case System.Drawing.Imaging.PixelFormat.Format1bppIndexed:
                    bpc = 1;
                    break;

                default:

                    Bitmap bm = new Bitmap(bmp.Width, bmp.Height, System.Drawing.Imaging.PixelFormat.Format24bppRgb);

                    //obtain a Graphics object for the new image and draw the old image 
                    //onto it using DrawImage 


                    Graphics gr = Graphics.FromImage(bm);
                    Rectangle rect = new Rectangle(0, 0, bm.Width, bm.Height);
                    gr.DrawImage(bm, rect, 0, 0, bm.Width, bm.Height, GraphicsUnit.Pixel);
                    break;
            }

            // Lock the bitmap's bits.  
            Rectangle rect1 = new Rectangle(0, 0, bmp.Width, bmp.Height);
            System.Drawing.Imaging.BitmapData bmpData =
                bmp.LockBits(rect1, System.Drawing.Imaging.ImageLockMode.ReadWrite,
                bmp.PixelFormat);

            // Declare an array to hold the bytes of the bitmap.
            int bytes = bmp.Height * bmpData.Stride;
            byte[] rgbValues = new byte[bytes];

            // Copy the RGB values into the array.
            for (int scanLine = bmp.Height - 1; scanLine >= 0; scanLine--)
            {
                // Get the address of the Nth scanline.
                IntPtr ptr = new IntPtr((int)bmpData.Scan0 + scanLine * bmpData.Stride);

                System.Runtime.InteropServices.Marshal.Copy(ptr, rgbValues, bmpData.Stride * (bmp.Height - scanLine - 1), bmpData.Stride);
            }

            //set picture paramters
            objTypePicture["Top"] = 0;
            objTypePicture["Left"] = 0;
            objTypePicture["Bottom"] = 5000;
            objTypePicture["Right"] = 5000;
            objTypePicture["BitsPerComponent"] = bpc;
            objTypePicture["BorderWidth"] = 2;
            objTypePicture["BitmapWidth"] = bmp.Width;
            objTypePicture["BitmapHeight"] = bmp.Height;
            objTypePicture["BitsPerComponent"] = bpc;
            objTypePicture["BitmapData"] = rgbValues;

            // Unlock the bits.
            bmp.UnlockBits(bmpData);

            //Change report state
            _axPdf.ReportState = ReportStateConstants.acReportStateRun;

            _axPdf.AutoRefresh = 1; //Set to True to render change
            _axPdf.Refresh();

            //save the new document
            _axPdf.Save(requiredPath + "\\Resulting_Docs\\LoadPicFile_resulting.pdf", 
                                               FileSaveOptionConstants.acFileSaveView);
        }


        /// <summary>
        /// The ContextSensitiveMenu event is fired when the user right-clicks on an object and when the document is in
        /// Annotate, Design, and Run mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_ContextSensitiveMenu(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_ContextSensitiveMenuEvent e)
        {
            MessageBox.Show("OK");
            //Set continue to 0 and handle the event
            e.@continue = 0;
        }

    

        /// <summary>
        /// This method illustrates how to create a polygon object
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreatePoly_Click(object sender, EventArgs e)
        {
           
            _axPdf.DoCommandTool(CommandToolConstants.acCommandToolDesignMode);

            int[] ops = new int[6];
            ops[0] = 6;
            ops[1] = 2;
            ops[2] = 2;
            ops[3] = 2;
            ops[4] = 2;
            ops[5] = 2;

            _axPdf.CreateObject(ObjectTypeConstants.acObjectTypePolygon, "Polygon");
            IacObject objTypePolygon = _axPdf.GetObjectByName("Polygon");

            objTypePolygon["Top"] = 1000;
            objTypePolygon["Left"] = 1000;
            objTypePolygon["Right"] = 5500;
            objTypePolygon["Bottom"] = 6500;

            objTypePolygon["Points"] = 6;

            objTypePolygon["XPoints"] = new[] { 0, 3000, 9000, 9000, 3500, 0 };
            objTypePolygon["YPoints"] = new[] { 5000, 9000, 7500, 2000, 2000, 5000 };

            objTypePolygon["Text"] = "Amyuni Technologies";
            objTypePolygon["Operations"] = ops;
            objTypePolygon["StrokeColor"] = 0x00FF00;

            _axPdf.DoCommandTool(CommandToolConstants.acCommandToolRunDocument);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));
            //save the new document
            _axPdf.Save(requiredPath + "\\Resulting_Docs\\CreatePoly_resulting.pdf", 
                                          FileSaveOptionConstants.acFileSaveView);
        }


        /// <summary>
        /// Event fired when contents refeshed
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_RefreshEvent(object sender, EventArgs e)
        {
            /*   if (axPDF.RefreshEventReason != 0 &&  ACPDFCREACTIVEX.acRefreshEventReasons.acRefreshPageScrolled != 0)
               {
                   MessageBox.Show("DD");
               }
           */
        }


        //Event fired each time new object created
        private void axPDF_NewObject(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_NewObjectEvent e)
        {
            //Get the type of Attribute
            IacAttribute attribute = (IacAttribute)e.pObject.get_Evaluate("ObjectType");

            //Check if Object is FreeHand tool tool that has 
           /* if (Int32.Parse(attribute.Value.ToString()) == 8)
            {
                //Change thickness
                //0 = none
                //1 = simple
                //2 = double
                //3 = triple
                //4 = quadruple
                e.pObject["StrokeWidth"] = 4;
            }
            */

            //Check if Object is Checkbox
            if (Int32.Parse(attribute.Value.ToString()) == 21)
            {
                e.pObject["Text"] = "on";
            }
        }


        /// <summary>
        /// This method illustrates how to enumerate through fonts in a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetFonts_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\objects.pdf", "");

                //Get array of objects
                IacObject[] myObjArray
                    = (IacObject[])_axPdf.get_ObjectAttribute("Document", "Fonts");

                foreach (var o in myObjArray)
                {
                    var obj = (acObject) o;
                    MessageBox.Show(obj["FontName"].ToString());
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// The ExportToXPS method is used to export a PDF document to XPS format.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToXps_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {
                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                _axPdf.ExportToXPS(requiredPath + "\\Resulting_Docs\\ExportToXps_resulting.xps", 
                                      acXPSExportOptions.acXPSExportOptionsNone);

                MessageBox.Show  ("Export to XPS Done!");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


        /// <summary>
        /// This event is fired when a new object is added to a PDF document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_NewObject_1(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_NewObjectEvent e)
        {
            _lblStatus.Text = "";
 
            //Get the type of Attribute
            IacAttribute attribute = (IacAttribute)e.pObject.get_Evaluate("ObjectType");

            //Check if Object is FreeHand tool tool that has 
            /* if (Int32.Parse(attribute.Value.ToString()) == 8)
             {
                 //Change thickness
                 //0 = none
                 //1 = simple
                 //2 = double
                 //3 = triple
                 //4 = quadruple
                 e.pObject["StrokeWidth"] = 4;
             }
             * 
             * 
             */
  

            //Check if Object is Checkbox
            if ((int)attribute.Value == 21)
            {
                _lblStatus.Text = "In New object: " + _intCounter;
                e.pObject["BackColor"] = 0x00FFFF;
                e.pObject["Text"] = "1";  //Off
               // e.pObject["Text"] = "0"; //On
                _intCounter++;
            }
        }

 


        /// <summary>
        /// This code snippet illustrates how to write metadata to the contents of a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddMetaData_Click(object sender, EventArgs e)
        {

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));

            try
            {

                _axPdf.Open(requiredPath + "\\Source_Docs\\Sales_invoice.pdf", "");

                StringBuilder sb = new StringBuilder();
                sb.Append ("<rdf:Description>");  //starting tag
                sb.Append("<myXLLtag>Amyuni XLM Tag</myXLLtag>");
                sb.Append("</rdf:Description>"); //ending tag

                //0: No metadata stream
                //1: Basic XMP metadata  generated by PDF Creator
                //2: Custom metadata stream generated by the calling application
                //3: PDF/A compatible matadata stream (Acrobat 8)
                //4:PDF/A compatible


                //In this example we add basic XMP metadata to document
                _axPdf.ObjectAttributeStr ("Document", "Metadata", "1");

                //Here we are adding custom XML data
                //This is not in our documentation
                _axPdf.ObjectAttributeStr("Document", "ExtraXMPMetadata", sb.ToString());

                _axPdf.Save(requiredPath + "\\Resulting_Docs\\AddMetaData_resulting.pdf", 
                                                FileSaveOptionConstants.acFileSaveView);


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This code snippet illustrates how to read metadata to the contents of a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnReadMetaData_Click(object sender, EventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));


            try
            {
                _axPdf.Open(requiredPath + "\\Resulting_Docs\\AddMetaData_resulting.pdf", "");

                //This returns the Metadata embeded in the document
                //This will also return an metadata added by ExtraXMPMetadata attribute
                var myMetaData = _axPdf.get_ObjectAttribute("Document", "MetadataStream").ToString();
                MessageBox.Show(myMetaData);

                //This returns metadata added by ExtraXMPMetadata attribute only
                myMetaData = _axPdf.get_ObjectAttribute("Document", "ExtraXMPMetadata").ToString();
                MessageBox.Show(myMetaData);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);

                //Metadata (the option)
                //MetadataStream (read/write string)
                //ExtraXMPMetadata (read/write XML string)

            }
        }


        private void btnAppendMultipleDocs_Click(object sender, EventArgs e)
        {
            //open a document to append using an instance of PDF Creator object
            PDFCreactiveXClass pdFdoc = new PDFCreactiveXClass();
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))));


            try
            {
                pdFdoc.SetLicenseKey(StrLicenseTo, StrActivationCode);

                pdFdoc.Open(requiredPath + "\\Source_Docs\\text.pdf", "");

                //Example: Append other PDF documents
                pdFdoc.Append(requiredPath + "\\Source_Docs\\tenpages.pdf", "");
                pdFdoc.Append(requiredPath + "\\Source_Docs\\CreateTextObject.pdf", "");
                pdFdoc.Append(requiredPath + "\\Source_Docs\\logo.pdf", "");
                pdFdoc.Append(requiredPath + "\\Source_Docs\\a.pdf", "");


                pdFdoc.Save(requiredPath + "\\Resulting_Docs\\AppendMultipleDocs_resulting.pdf",
                            FileSaveOptionConstants.acFileSaveView);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }



        /// <summary>
        /// This event is fired for each page saved by the control
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void axPDF_SavePageEvent(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_SavePageEvent e)
        {
          //  MessageBox.Show(e.pageNumber.ToString());
        }

        private void axPDF_MouseMoveEvent(object sender, AxACPDFCREACTIVEX._IPDFCreactiveXEvents_MouseMoveEvent e)
        {
            IacAttribute attribute = (IacAttribute)e.pObject.get_Evaluate("ObjectType");

            //Check if Object is PictureObject
            if ((int)attribute.Value == 7)
            {
                _axPdf.SetToolTipText("This is a picture");
            }
            else if ((int)attribute.Value == 6) //Field Object
            {
                _axPdf.SetToolTipText("This is a Field");
            }
        }
    }
}
